/******************************************************************************
 * File     :  LED03.c
 * Purpose  :  LED Blinker
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

//#include "12F675.inc"          // Use PIC12F675
//#include "16F628.inc"          // Use PIC16F628
#include "16F877.inc"          // Use PIC16F877

/***********************************************************************
 *	Constants
 ***********************************************************************/
#define LED_BLINKER  PIN_A0

/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void xDelay(void);
void LedBlinker(void);

/***********************************************************************
 * FUNCTION:     xDelay
 * DESCRIPTION:  Delay
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void xDelay(void) {

   delay_ms(1000);
}

/***********************************************************************
 * FUNCTION:     LedBlinker
 * DESCRIPTION:  LED Blinker
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void LedBlinker(void) {

   output_bit(LED_BLINKER,1);
   xDelay();
   output_bit(LED_BLINKER,0);
   xDelay();
}

/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   while(TRUE) {
      LedBlinker();
   }
}
