/******************************************************************************
 * File     :  ex01.c
 * Purpose  :  Basic Pointers
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Constants
 ***********************************************************************/
#define LED PIN_A0         // Constant

/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void LedOnOff(void);       // Prototype declaration


/* Function LedOnOff  : Sub function */
/***********************************************************************
 * FUNCTION:     LedOnOff
 * DESCRIPTION:  LED Blinker
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void LedOnOff(void) {

   output_high(LED);    // Turns the LED On
   delay_ms(1000);      // Delay 1000 milliseconds
   output_low(LED);     // Turns the LED off
   delay_ms(1000);
}

/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void){

   while(TRUE) {
   	LedOnOff();
   }
}

