/******************************************************************************
 * File     :  function01.c
 * Purpose  :  Determines functions
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mdoe HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void func01(void);
int func02(int x, int y);
void func03(int x, int y);
void func04(int *x, int *y);


/***********************************************************************
 * FUNCTION:     func01
 * DESCRIPTION:  function general
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void func01(void) {

	printf("in..func01\n\r");
}


/***********************************************************************
 * FUNCTION:     func02
 * DESCRIPTION:  function pass by value
 * PARAMETERS:   integer x , integer y
 * RETURNED:     integer
 ***********************************************************************/
int func02(int x, int y) {

   int z;

	z = x+y;
	printf("in..func02 %d\n\r",z);
	return(z);
}


/***********************************************************************
 * FUNCTION:     func03
 * DESCRIPTION:  function pass by value
 * PARAMETERS:   integer x , integer y
 * RETURNED:     nothing
 ***********************************************************************/
void func03(int x, int y) {

	int z;

	z = 10;
	x = x + z;
	y = y + z;
	printf("in..func03 x=%d , y=%d\n\r",x,y);
}


/***********************************************************************
 * FUNCTION:     func04
 * DESCRIPTION:  function pass by reference
 * PARAMETERS:   integer pointer x , integer pointer y
 * RETURNED:     nothing
 ***********************************************************************/
void func04(int *x, int *y) {

   int z;

	z = 10;
	*x = *x + z;
	*y = *y + z;
	printf("in..func04 x=%d , y=%d\n\r",*x,*y);
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

	int i,j,k;

	i = 10;
	j = 20;

	func01();
	k = func02(i, j);
	printf("k = %d\n\r",k);

	printf("\n\npass by value\n\r");
	printf("before in..func03 i=%d , j=%d\n\r",i,j);
	func03(i, j);
	printf("after  in..func03 i=%d , j=%d\n\r",i,j);

	printf("\n\npass by reference\n\r");
	printf("before in..func04 i=%d , j=%d\n\r",i,j);
	func04(&i, &j);
	printf("after  in..func04 i=%d , j=%d\n\r",i,j);

	while (TRUE);
}
