/******************************************************************************
 * File     :  push.c
 * Purpose  :  push switch interrupt function
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Constants
 ***********************************************************************/
#define PUSHSWITCH  PIN_B7    // define for push switch
#define LED01       PIN_B0    // define show Hook Interrupt
#define LED02       PIN_B1    // define Show led in Loop

#define debounce(x)    delay_ms(x)  // Macros

/***********************************************************************
 *	Global variables
 ***********************************************************************/
short int HookKey=0;


/***********************************************************************
 * FUNCTION:     PushSw_isr
 * DESCRIPTION:  push switch key interrupt
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
#int_rb
void PushSw_isr() {

   if(input(PUSHSWITCH)) {
      HookKey=TRUE;
   }
   debounce(100);    // switch to debounce
}


/***********************************************************************
 * FUNCTION:     xDelay
 * DESCRIPTION:  Delay
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void xDelay(void) {

   delay_ms(1000);
}


/***********************************************************************
 * FUNCTION:    main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   enable_interrupts(INT_RB);    // Port B any change on B4-B7
   enable_interrupts(GLOBAL);

   set_tris_b(0xF0);
   output_low(LED01);
   output_low(LED02);

   while (TRUE) {

      if(HookKey) {
        printf("HooK Interrupt key\n\r");
        output_low(LED02);
        output_high(LED01);
        xDelay();
        HookKey=FALSE;
      } else {
        output_low(LED01);
      }
      output_high(LED02);
   }
}
