/******************************************************************************
 * File     :  ametic.c
 * Purpose  :  Arithmetic Operators
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

/***********************************************************************
 *	Includes
 ***********************************************************************/
#include <math.h>             // Prototypes for match Library functions.
#include <stdlib.h>           // Prototypes for standard Library functions.
#include "INPUT.C"            // Module Function


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

	float i, j, k;

	printf("Program Demo Arithmetic Operators\n\r");

	while(TRUE) {

		printf("\n\rEnter Floating numbers:");
      i = get_float();

		printf("\n\rEnter Floating numbers:");
      j = get_float();

		printf("\n\rArithmetic Operators\n\r");
		printf("%2f + %2f = %2f\n\r",i,j,i+j);
		printf("%2f - %2f = %2f\n\r",i,j,i-j);
		printf("%2f * %2f = %2f\n\r",i,j,i*j);

		if(j!=0) {
			printf("%f / %f = %f\n\r",i,j,i/j);
			printf("%f %% %f = %f\n\r",i,j,fmod(i,j));
		} else {
			printf("%f / %f = 0\n\r",i,j);
			printf("%f %% %f = 0\n\r",i,j);
		}
	}
}
