/******************************************************************************
 * File     :  bitwise.c
 * Purpose  :  Bitwise Operators
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 * FUNCTION:     dsp_bit_pattern
 * DESCRIPTION:  Display bit pattern(Ref.Programming with C:Byron S. Gottfried)
 * PARAMETERS:   i
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_bit_pattern(int i) {

	int b, m, count, nbits;
	unsigned mask;

	nbits = 8 * sizeof(int);
	m = 0x1 << (nbits - 1);

	mask = m;
	for(count=1; count<=nbits; count++) {
		b = (i & mask) ? 1 : 0;
		printf("%d",b);
		if(count % 4 == 0)
			printf(" ");
		mask >>= 1;
	}
	printf("\n\r");
}

/***********************************************************************
 * FUNCTION:    main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int i,j;

	printf("\nProgram Demo Bitwise Operators\n\r");

	i = 0x01;
	j = 0x08;

	printf("i      : ");
	dsp_bit_pattern(i);

	printf("i << 1 : ");
	dsp_bit_pattern(i<<1);

	printf("i << 5 : ");
	dsp_bit_pattern(i<<5);

	printf("j      : ");
	dsp_bit_pattern(j);

	printf("j >> 2 : ");
	dsp_bit_pattern(j>>2);

	i = 0x09;
	j = 0x0F;

	printf("i      : ");
	dsp_bit_pattern(i);

	printf("j      : ");
	dsp_bit_pattern(j);

	printf("i & j  : ");
	dsp_bit_pattern(i&j);

	printf("i | j  : ");
	dsp_bit_pattern(i|j);

	printf("~j     : ");
	dsp_bit_pattern(~j);

	while(TRUE);
}
