/******************************************************************************
 * File     :  ex03.c
 * Purpose  :  Basic Pointers 3
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void CallNumberPtr(int *n);


/***********************************************************************
 * FUNCTION:     CallNumberPtr
 * DESCRIPTION:  function pointer
 * PARAMETERS:   *n
 * RETURNED:     nothing
 ***********************************************************************/
void CallNumberPtr(int *n) {

   *n += 5;
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void){

   int i=20;

   printf("\r\n");
   printf("Before Call Call By Value function i = %d\r\n",i);
   CallNumberPtr(i);
   printf("After Call Call By Value function i = %d\r\n\n",i);

   printf("\r\n\n");
   printf("Before Call Call By Reference  function i = %d\r\n",i);
   CallNumberPtr(&i);
   printf("Before Call Call By Reference function i = %d\r\n\n",i);
}
