/******************************************************************************
 * File     :  ex01.c
 * Purpose  :  Basic Structures
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mdoe HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Data Types
 ***********************************************************************/
typedef struct{
            int day;
            int month;
            int year;
        }bdate;


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   struct {
      int id_no;
      char fname[15];
      char lname[20];
      int age;
      bdate birthday;
   }person, *ptr = &person;


   printf("\r\nNumber of bytes hex: %x , dec: %d", sizeof *ptr,sizeof *ptr);
   printf("\r\nStarting address hex : %x , dec: %d", ptr, ptr);
   printf("\r\n");

   strcpy(ptr->fname,"PIC C");
   strcpy(ptr->lname,"CCS C Compiler");
   ptr->id_no = 2;
   ptr->age = 25;
   ptr->birthday.day = 9;
   ptr->birthday.month = 1;
   ptr->birthday.year = 47;

   printf("\r\nFirst Name: %s ",ptr->fname);
   printf("\r\nLast Name: %s ",ptr->lname);
   printf("\r\nID No. : %d",ptr->id_no);
   printf("\r\nBirthday");
   printf("\r\nDay  : %d",ptr->birthday.day);
   printf("\r\nMonth: %d",ptr->birthday.month);
   printf("\r\nYear : %d",ptr->birthday.year);

   while(TRUE);
}
