Attribute VB_Name = "Temp_P"
' Public variables
Public Echo As Boolean        ' Echo On/Off flag.
Public CancelSend As Integer  ' Flag to stop sending a text file.

Declare Sub setwindowpos Lib "user32" Alias "SetWindowPos" (ByVal hwnd As Long, ByVal hwndinsertafter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wflags As Long)

Global Const STX = &H2     'Start of text
Global Const ETX = &H3     'End of text
Global Const EOT = &H4     'End of transmission

Global Const ACK = &H6     'Acknowledge
Global Const NAK = &H15    'Negative acknowledgement
Global Const ETB = &H17    'End of transmission block
Global Const FS = &H1C     'Field separator
Global Const GS = &H1D     'Group separator
Global Const RS = &H1E     'Record separator
Global Const CR = &HD      'Carriage return
Global Const LF = &HA      'Carriage return

Global Const TEMP_START = &H20
Global Const PROCESS_STOP = &H21
Global Const EEPROM_READ = &H22
Global Const EEPROM_WRITE = &H23
Global Const EEPROM_STOP = &H24
Global Const INIT_STATUS = &H25
Global Const TIME_SET_S = &H26
Global Const TIME_SET_M = &H27
Global Const TIME_NOTUSE = &H28
Global Const TIME_SET_TRIGGER = &H29
Global Const IO_SET_CONTROL = &H30

#Const TYPE_ONE = True
#Const TYPE_TWO = False

Global HOOK_Record As Boolean
Global BREAK_STEP As Boolean
Global Ds

Global data_logger(130)

Global b_arrow As Boolean

Dim d_FldLIS() As String
Dim txtFilename As String

Public Sub Temp_ReadProtocol(data As String)
Dim MyChar
Static sw_task As Integer
Static str_data As String
Dim i As Integer, j As Integer, k As Integer
    
    iLen = Len(data)
    For i = 1 To iLen
       MyChar = Mid(data, i, 1)
'       Debug.Print MyChar & " Hex: " & Hex(Asc(MyChar))     ' Print to the Immediate window.
        Select Case Asc(MyChar)
        Case Asc("T"):    ' Data Temperature
            sw_task = 1
'            Debug.Print "Task Temperature"
        Case Asc("E"):    ' Read Data EEPROM
            sw_task = 2
'            Debug.Print "Task EEPROM"
        Case Asc("I"):
            sw_task = 3
        Case Asc("S"):    ' Stop or End of Data
            If sw_task = 1 Then
                frmTerminal.lblTempC.Caption = Str(Val(str_data))
                TempMini.Label1.Caption = Str(Val(str_data))
                
                frmTerminal.lblTempF.Caption = Str(((Val(str_data) * 9) / 5) + 32)
                frmTerminal.ListTempC.AddItem Date & "  " & Time & " = " & frmTerminal.lblTempC.Caption
                frmTerminal.ListTempF.AddItem Date & "  " & Time & " = " & frmTerminal.lblTempF.Caption
                str_data = ""
                If b_arrow Then
                    TempMini.Label1.ForeColor = &HFF&
                    b_arrow = False
                Else
                    TempMini.Label1.ForeColor = &H80000012
                    b_arrow = True
                End If
            End If
            If sw_task = 2 Then
'                Debug.Print str_data
                k = 1
                For j = 0 To 126
                    data_logger(j) = Mid(str_data, k, 2)
'                    Debug.Print j & ":" & data_logger(j)
                    k = k + 2
                Next
                frmDataLogger.Show
                str_data = ""
            End If
            If sw_task = 3 Then
                If Val(Mid(str_data, 2, 1)) = 1 Then
                    frmTerminal.Label8.Caption = "Data Logger : ON"
                    frmTerminal.Command3.Caption = "OFF"
                Else
                    frmTerminal.Label8.Caption = "Data Logger : OFF"
                    frmTerminal.Command3.Caption = "ON"
                End If
                frmTerminal.Label9.Caption = "Time trigger TL: " & Val("&H" & Mid(str_data, 5, 2)) & " TH: " & Val("&H" & Mid(str_data, 3, 2))
                str_data = ""
                
            End If
            sw_task = 0
            
        Case Else
            str_data = str_data & MyChar
            
        End Select
    Next

End Sub

Public Sub SaveRecTempToDB()
Dim dbsCurrent As Database
Dim rstRec As Recordset
Dim rstTU As Recordset
Dim dbBASE As String
    
    dbBASE = App.Path & "\RecDb.MDB"
    Set dbsCurrent = OpenDatabase(dbBASE)
    Set rstRec = dbsCurrent.OpenRecordset("tblDbRec", dbOpenDynaset)
    Set rstTU = dbsCurrent.OpenRecordset("tblDbTU", dbOpenDynaset)
       
    With rstRec
        .AddNew
        .Update
    End With
    
    rstRec.Close
    rstTU.Close
    dbsCurrent.Close

End Sub

Public Sub SaveRecTempToFile()
On Error GoTo ErrH
Dim i As Long
Dim strfile As String
Dim strdate As String
Dim strAppPath As String
Dim txtFilename As String
Dim FileNumber

    strAppPath = App.Path
    FileNumber = FreeFile   ' Get unused file
    
    strdate = (Format(Now, "yyyy") - 543) & Format(Now, "mm") & Format(Now, "dd")
    strfile = strAppPath & "\"
    strdate = strdate & ".PRN"
    txtFilename = strfile & strdate
    
    Open txtFilename For Append As #FileNumber
    For i = 1 To frmTerminal.ListTempC.ListCount
'        Write #FileNumber, ListTempC.List(i)
        Print #FileNumber, frmTerminal.ListTempC.List(i)
    Next
    Close #FileNumber
    frmTerminal.ListTempC.Clear
    frmTerminal.ListTempF.Clear
    
    Exit Sub
ErrH:
    MsgBox Err.Description
End Sub

