VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "Comdlg32.ocx"
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmTerminal 
   Caption         =   "Temperature Mini Board"
   ClientHeight    =   5100
   ClientLeft      =   900
   ClientTop       =   1605
   ClientWidth     =   8880
   ForeColor       =   &H00000000&
   Icon            =   "frmComm.frx":0000
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   5100
   ScaleWidth      =   8880
   Begin VB.Frame Frame5 
      Caption         =   "I/O Control "
      Height          =   1335
      Left            =   120
      TabIndex        =   27
      Top             =   2640
      Width           =   6015
      Begin VB.CommandButton Command2 
         Caption         =   "OFF ALL"
         Height          =   375
         Index           =   1
         Left            =   4200
         TabIndex        =   39
         Top             =   720
         Width           =   1455
      End
      Begin VB.CommandButton Command2 
         Caption         =   "ON ALL"
         Height          =   375
         Index           =   0
         Left            =   4200
         TabIndex        =   38
         Top             =   240
         Width           =   1455
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RB7"
         Height          =   375
         Index           =   9
         Left            =   3120
         TabIndex        =   37
         Top             =   720
         Width           =   1455
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RB6"
         Height          =   375
         Index           =   8
         Left            =   2400
         TabIndex        =   36
         Top             =   720
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RB5"
         Height          =   375
         Index           =   7
         Left            =   1680
         TabIndex        =   35
         Top             =   720
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RB4"
         Height          =   375
         Index           =   6
         Left            =   960
         TabIndex        =   34
         Top             =   720
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RB3"
         Height          =   375
         Index           =   5
         Left            =   240
         TabIndex        =   33
         Top             =   720
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RA5"
         Height          =   375
         Index           =   4
         Left            =   3120
         TabIndex        =   32
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RA3"
         Height          =   375
         Index           =   3
         Left            =   2400
         TabIndex        =   31
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RA2"
         Height          =   375
         Index           =   2
         Left            =   1680
         TabIndex        =   30
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RA1"
         Height          =   375
         Index           =   1
         Left            =   960
         TabIndex        =   29
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox Check1 
         Caption         =   "RA0"
         Height          =   375
         Index           =   0
         Left            =   240
         TabIndex        =   28
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "TIME SET"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   222
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      MaskColor       =   &H8000000F&
      TabIndex        =   24
      Top             =   2040
      UseMaskColor    =   -1  'True
      Width           =   1095
   End
   Begin VB.Frame Frame4 
      Caption         =   "Status "
      Height          =   615
      Left            =   120
      TabIndex        =   22
      Top             =   4080
      Width           =   6015
      Begin VB.Label Label9 
         Caption         =   "Time trigger : "
         Height          =   255
         Left            =   3600
         TabIndex        =   26
         Top             =   240
         Width           =   2295
      End
      Begin VB.Label Label7 
         Caption         =   "Time Set : "
         Height          =   255
         Left            =   1680
         TabIndex        =   25
         Top             =   240
         Width           =   1815
      End
      Begin VB.Label Label8 
         Caption         =   "Data Logger : "
         Height          =   255
         Left            =   120
         TabIndex        =   23
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.CommandButton Command6 
      Caption         =   "READ"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   222
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   5280
      TabIndex        =   20
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton Command5 
      Caption         =   "SAVE"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   222
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2520
      TabIndex        =   19
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton Command3 
      Caption         =   "ON"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   222
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   4440
      TabIndex        =   17
      Top             =   2040
      Width           =   735
   End
   Begin VB.Frame Frame3 
      Caption         =   "Tempperature "
      Height          =   615
      Left            =   6240
      TabIndex        =   12
      Top             =   4080
      Width           =   2535
      Begin VB.OptionButton Option2 
         Caption         =   "Option2"
         Height          =   255
         Left            =   1080
         TabIndex        =   14
         Top             =   240
         Width           =   255
      End
      Begin VB.OptionButton Option1 
         Caption         =   "Option1"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   240
         Width           =   255
      End
      Begin VB.Label Label4 
         Caption         =   "Fahrenheit"
         Height          =   255
         Left            =   1320
         TabIndex        =   16
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label3 
         Caption         =   "Celsius"
         Height          =   255
         Left            =   360
         TabIndex        =   15
         Top             =   240
         Width           =   615
      End
   End
   Begin VB.ListBox ListTempC 
      Height          =   3180
      Left            =   6240
      TabIndex        =   10
      Top             =   840
      Width           =   2535
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   9000
      Top             =   2040
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   4
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmComm.frx":0442
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmComm.frx":0894
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmComm.frx":0CE6
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "frmComm.frx":1138
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Timer Timer2 
      Enabled         =   0   'False
      Interval        =   2000
      Left            =   9000
      Top             =   1080
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   9000
      Top             =   1560
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   9000
      Top             =   2760
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   0   'False
      NullDiscard     =   -1  'True
      RThreshold      =   1
      RTSEnable       =   -1  'True
      SThreshold      =   1
      InputMode       =   1
   End
   Begin MSComDlg.CommonDialog OpenLog 
      Left            =   9000
      Top             =   480
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DefaultExt      =   "LOG"
      FileName        =   "Open Communications Log File"
      Filter          =   "Log File (*.log)|*.log;"
      FilterIndex     =   501
      FontSize        =   9.02458e-38
   End
   Begin MSComctlLib.StatusBar sbrStatus 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   4785
      Width           =   8880
      _ExtentX        =   15663
      _ExtentY        =   556
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   3
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Text            =   "Status:"
            TextSave        =   "Status:"
            Key             =   "Status"
            Object.ToolTipText     =   "Communications Port Status"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   11326
            MinWidth        =   2
            Text            =   "Settings:"
            TextSave        =   "Settings:"
            Key             =   "Settings"
            Object.ToolTipText     =   "Communications Port Settings"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Object.Width           =   1244
            MinWidth        =   1244
            Key             =   "ConnectTime"
            Object.ToolTipText     =   "Connect Time"
         EndProperty
      EndProperty
   End
   Begin VB.Frame Frame1 
      Caption         =   "Temperature "
      Height          =   1215
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   6015
      Begin VB.Label Label2 
         Caption         =   "o"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   18
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Index           =   1
         Left            =   5280
         TabIndex        =   8
         Top             =   120
         Width           =   255
      End
      Begin VB.Label Label1 
         Caption         =   "F"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Index           =   1
         Left            =   5520
         TabIndex        =   7
         Top             =   360
         Width           =   375
      End
      Begin VB.Label Label2 
         Caption         =   "o"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   18
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Index           =   0
         Left            =   2280
         TabIndex        =   6
         Top             =   120
         Width           =   255
      End
      Begin VB.Label Label1 
         Caption         =   "C"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Index           =   0
         Left            =   2520
         TabIndex        =   5
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblTempF 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "F"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Left            =   3120
         TabIndex        =   4
         Top             =   360
         Width           =   2100
      End
      Begin VB.Label lblTempC 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "C"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   24
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Left            =   120
         TabIndex        =   3
         Top             =   360
         Width           =   2100
      End
   End
   Begin MSComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   420
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   8880
      _ExtentX        =   15663
      _ExtentY        =   741
      ButtonWidth     =   609
      ButtonHeight    =   582
      Appearance      =   1
      ImageList       =   "ImageList1"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   7
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "connect"
            Object.ToolTipText     =   "Connect Temp Mini Board"
            ImageIndex      =   1
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "disconnect"
            Object.ToolTipText     =   "Disconnect Temp Mini Board"
            ImageIndex      =   2
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Object.ToolTipText     =   "Disconnect Temp Mini Board"
            Style           =   3
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "graph_temp"
            Object.ToolTipText     =   "Temperature Graphics"
            ImageIndex      =   3
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "temp_mini"
            Object.ToolTipText     =   "Small Window"
            ImageIndex      =   4
         EndProperty
      EndProperty
      BorderStyle     =   1
      Begin VB.Frame Frame2 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         ForeColor       =   &H80000008&
         Height          =   350
         Left            =   8300
         TabIndex        =   9
         Top             =   70
         Width           =   255
         Begin VB.Image imgConnected 
            Height          =   255
            Left            =   0
            Picture         =   "frmComm.frx":158A
            Stretch         =   -1  'True
            ToolTipText     =   "Toggles Port"
            Top             =   0
            Width           =   240
         End
         Begin VB.Image imgNotConnected 
            Height          =   255
            Left            =   0
            Picture         =   "frmComm.frx":16D4
            Stretch         =   -1  'True
            ToolTipText     =   "Toggles Port"
            Top             =   0
            Width           =   240
         End
      End
   End
   Begin VB.ListBox ListTempF 
      Height          =   3180
      Left            =   6240
      TabIndex        =   11
      Top             =   840
      Width           =   2535
   End
   Begin VB.Label Label6 
      Caption         =   "Date             Time          Temp"
      Height          =   255
      Left            =   6240
      TabIndex        =   21
      Top             =   600
      Width           =   2535
   End
   Begin VB.Label Label5 
      Appearance      =   0  'Flat
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   " Tempperature :                                               Data Logger :"
      ForeColor       =   &H80000008&
      Height          =   615
      Left            =   120
      TabIndex        =   18
      Top             =   1920
      Width           =   6015
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuOpenLog 
         Caption         =   "&Open Log File..."
      End
      Begin VB.Menu mnuCloseLog 
         Caption         =   "&Close Log File"
         Enabled         =   0   'False
      End
      Begin VB.Menu M3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuPort 
      Caption         =   "&CommPort"
      Begin VB.Menu mnuOpen 
         Caption         =   "Port &Open"
      End
      Begin VB.Menu MBar1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuProperties 
         Caption         =   "Properties..."
      End
   End
   Begin VB.Menu mnuMSComm 
      Caption         =   "&MSComm"
      Enabled         =   0   'False
      Visible         =   0   'False
      Begin VB.Menu mnuInputLen 
         Caption         =   "&InputLen..."
      End
      Begin VB.Menu mnuRThreshold 
         Caption         =   "&RThreshold..."
      End
      Begin VB.Menu mnuSThreshold 
         Caption         =   "&SThreshold..."
      End
      Begin VB.Menu mnuParRep 
         Caption         =   "P&arityReplace..."
      End
      Begin VB.Menu mnuDTREnable 
         Caption         =   "&DTREnable"
      End
      Begin VB.Menu Bar3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHCD 
         Caption         =   "&CDHolding..."
      End
      Begin VB.Menu mnuHCTS 
         Caption         =   "CTSH&olding..."
      End
      Begin VB.Menu mnuHDSR 
         Caption         =   "DSRHo&lding..."
      End
   End
   Begin VB.Menu M5 
      Caption         =   "Data"
      Begin VB.Menu mnuData 
         Caption         =   "Data"
      End
      Begin VB.Menu mnuClearTemp 
         Caption         =   "Clear Temp.."
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "About"
      Begin VB.Menu mnuContact 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmTerminal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'--------------------------------------------------
' VBTerm - This is a demonstration program for the MSComm
' communications ActiveX control.
'
' Copyright (c) 1994, Crescent Software, Inc.
' by Don Malin and Carl Franklin.
'
' Updated by Mike Maddox
'--------------------------------------------------
Option Explicit

Dim Ret As Integer      ' Scratch integer.
Dim Temp As String      ' Scratch string.
Dim hLogFile As Integer ' Handle of open log file.
Dim StartTime As Date   ' Stores starting time for port timer

Private Sub Check1_Click(Index As Integer)
Dim i As Integer
Dim j As Integer

    Debug.Print Index
    Debug.Print Check1.Item(Index).Value

    If MSComm1.PortOpen = False Then Exit Sub
    
    MSComm1.Output = Chr$(STX)
    MSComm1.Output = Chr$(IO_SET_CONTROL)
    MSComm1.Output = Chr$(Index + 10)
    MSComm1.Output = Chr$(Check1.Item(Index).Value)
    MSComm1.Output = Chr$(ETX)
    
End Sub

Private Sub Command1_Click()

    frmSetTime.Show
    
End Sub

Private Sub Command2_Click(Index As Integer)
Dim i As Integer

    If MSComm1.PortOpen = False Then Exit Sub
   
    If Index = 0 Then
            MSComm1.Output = Chr$(STX)
            MSComm1.Output = Chr$(IO_SET_CONTROL)
            MSComm1.Output = Chr$(20)
            MSComm1.Output = Chr$(1)
            MSComm1.Output = Chr$(ETX)
            For i = 0 To 9
            Check1.Item(i) = 1
            Next
    End If
    If Index = 1 Then
            MSComm1.Output = Chr$(STX)
            MSComm1.Output = Chr$(IO_SET_CONTROL)
            MSComm1.Output = Chr$(20)
            MSComm1.Output = Chr$(0)
            MSComm1.Output = Chr$(ETX)
            For i = 0 To 9
            Check1.Item(i) = 0
            Next
    End If

End Sub

Private Sub Command3_Click()

    If MSComm1.PortOpen = False Then Exit Sub
    
    If Command3.Caption = "ON" Then
        MSComm1.Output = Chr$(STX)
        MSComm1.Output = Chr$(EEPROM_WRITE)
        MSComm1.Output = Chr$(ETX)
        Command3.Caption = "OFF"
        Label8.Caption = "Data Logger : ON"
    Else
        MSComm1.Output = Chr$(STX)
        MSComm1.Output = Chr$(EEPROM_STOP)
        MSComm1.Output = Chr$(ETX)
        Command3.Caption = "ON"
        Label8.Caption = "Data Logger : OFF"
    End If

End Sub

Private Sub Command5_Click()

    Call SaveRecTempToFile

End Sub


Private Sub Command6_Click()
Dim i As Integer

    If MSComm1.PortOpen = False Then Exit Sub
    MSComm1.Output = Chr$(STX)
    MSComm1.Output = Chr$(PROCESS_STOP)
    MSComm1.Output = Chr$(ETX)
    MSComm1.Output = Chr$(STX)
    MSComm1.Output = Chr$(EEPROM_READ)
    MSComm1.Output = Chr$(ETX)
    
End Sub

Private Sub Form_Load()
Dim CommPort As String, Handshaking As String, Settings As String
Dim RN As String
        
On Error Resume Next
    
    RN = Trim(GetSetting(App.Title, "Express", "ExpressSN", ""))
    
    HOOK_Record = False
    Option1.Value = True
    Label8.Caption = "Data Logger :"
    
    ' Set the default color for the terminal
    frmData.txtTerm.SelLength = Len(frmData.txtTerm)
    frmData.txtTerm.SelText = ""
    frmData.txtTerm.ForeColor = vbBlue
              
    ' Set Title
    App.Title = "Express"
    
    ' Set up status indicator light
    imgNotConnected.ZOrder
       
    ' Center Form
    frmTerminal.Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
    
    ' Load Registry Settings
    
    Settings = GetSetting(App.Title, "Properties", "Settings", "") ' frmTerminal.MSComm1.Settings]\
    If Settings <> "" Then
        MSComm1.Settings = Settings
        If Err Then
            MsgBox Error$, 48
            Exit Sub
        End If
    End If
    
    CommPort = GetSetting(App.Title, "Properties", "CommPort", "") ' frmTerminal.MSComm1.CommPort
    If CommPort <> "" Then MSComm1.CommPort = CommPort
    
    Handshaking = GetSetting(App.Title, "Properties", "Handshaking", "") 'frmTerminal.MSComm1.Handshaking
    If Handshaking <> "" Then
        MSComm1.Handshaking = Handshaking
        If Err Then
            MsgBox Error$, 48
            Exit Sub
        End If
    End If
    
    Echo = GetSetting(App.Title, "Properties", "Echo", "") ' Echo
    On Error GoTo 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim Counter As Long

    If MSComm1.PortOpen Then
       ' Wait 10 seconds for data to be transmitted.
       Counter = Timer + 10
       Do While MSComm1.OutBufferCount
          Ret = DoEvents()
          If Timer > Counter Then
             Select Case MsgBox("Data cannot be sent", 34)
                ' Cancel.
                Case 3
                   Cancel = True
                   Exit Sub
                ' Retry.
                Case 4
                   Counter = Timer + 10
                ' Ignore.
                Case 5
                   Exit Do
             End Select
          End If
       Loop

       MSComm1.PortOpen = 0
    End If

    ' If the log file is open, flush and close it.
    If hLogFile Then mnuCloseLog_Click
    End
End Sub

Private Sub imgConnected_Click()
    ' Call the mnuOpen_Click routine to toggle connect and disconnect
    Call mnuOpen_Click
'    lblLinkLIS.Caption = "<= DisConnect"
End Sub

Private Sub imgNotConnected_Click()
    ' Call the mnuOpen_Click routine to toggle connect and disconnect
    Call mnuOpen_Click
'    lblLinkLIS.Caption = "< =Connect"
End Sub


Private Sub mnuClearTemp_Click()

    ListTempC.Clear
    ListTempF.Clear

End Sub

Private Sub mnuCloseLog_Click()
    ' Close the log file.
    Close hLogFile
    hLogFile = 0
    mnuOpenLog.Enabled = True
    mnuCloseLog.Enabled = False
    frmTerminal.Caption = "644Fast4System"
End Sub


Private Sub mnuContact_Click()
Dim msg_about As String

'    msg_about = "Temperature Mini Board" & Chr(13) & Chr(10) & "Contacts : 01-431-6541"
'    MsgBox msg_about, vbDefaultButton1 + vbInformation, "About"

    frmAbout.Show

End Sub

Private Sub mnuData_Click()

    frmData.Show

End Sub

' Toggle the DTREnabled property.
Private Sub mnuDTREnable_Click()
    ' Toggle DTREnable property
    MSComm1.DTREnable = Not MSComm1.DTREnable
    mnuDTREnable.Checked = MSComm1.DTREnable
End Sub


Private Sub mnuFileExit_Click()
    ' Use Form_Unload since it has code to check for unsent data and an open log file.
    Form_Unload Ret
End Sub


' Display the value of the CDHolding property.
Private Sub mnuHCD_Click()
    If MSComm1.CDHolding Then
        Temp = "True"
    Else
        Temp = "False"
    End If
    MsgBox "CDHolding = " + Temp
End Sub

' Display the value of the CTSHolding property.
Private Sub mnuHCTS_Click()
    If MSComm1.CTSHolding Then
        Temp = "True"
    Else
        Temp = "False"
    End If
    MsgBox "CTSHolding = " + Temp
End Sub

' Display the value of the DSRHolding property.
Private Sub mnuHDSR_Click()
    If MSComm1.DSRHolding Then
        Temp = "True"
    Else
        Temp = "False"
    End If
    MsgBox "DSRHolding = " + Temp
End Sub

' This procedure sets the InputLen property, which determines how
' many bytes of data are read each time Input is used
' to retreive data from the input buffer.
' Setting InputLen to 0 specifies that
' the entire contents of the buffer should be read.
Private Sub mnuInputLen_Click()
    On Error Resume Next

    Temp = InputBox$("Enter New InputLen:", "InputLen", Str$(MSComm1.InputLen))
    If Len(Temp) Then
        MSComm1.InputLen = Val(Temp)
        If Err Then MsgBox Error$, 48
    End If
End Sub

Private Sub mnuProperties_Click()
  ' Show the CommPort properties form
  frmProperties.Show vbModal
  
End Sub

' Toggles the state of the port (open or closed).
Private Sub mnuOpen_Click()
    On Error Resume Next
    Dim OpenFlag

    MSComm1.PortOpen = Not MSComm1.PortOpen
    If Err Then MsgBox Error$, 48
    
    OpenFlag = MSComm1.PortOpen
    
    mnuOpen.Checked = OpenFlag
        
    If MSComm1.PortOpen Then
        imgConnected.ZOrder
        sbrStatus.Panels("Settings").Text = "Settings: " & MSComm1.Settings
        StartTiming
    Else
        imgNotConnected.ZOrder
        sbrStatus.Panels("Settings").Text = "Settings: "
        StopTiming
    End If
    
End Sub

Private Sub mnuOpenLog_Click()
   Dim replace
   On Error Resume Next
   OpenLog.Flags = cdlOFNHideReadOnly Or cdlOFNExplorer
   OpenLog.CancelError = True
      
   ' Get the log filename from the user.
   OpenLog.DialogTitle = "Open Communications Log File"
   OpenLog.Filter = "Log Files (*.LOG)|*.log|All Files (*.*)|*.*"
   
   Do
      OpenLog.FileName = ""
      OpenLog.ShowOpen
      If Err = cdlCancel Then Exit Sub
      Temp = OpenLog.FileName

      ' If the file already exists, ask if the user wants to overwrite the file or add to it.
      Ret = Len(Dir$(Temp))
      If Err Then
         MsgBox Error$, 48
         Exit Sub
      End If
      If Ret Then
         replace = MsgBox("Replace existing file - " + Temp + "?", 35)
      Else
         replace = 0
      End If
   Loop While replace = 2

   ' User clicked the Yes button, so delete the file.
   If replace = 6 Then
      Kill Temp
      If Err Then
         MsgBox Error$, 48
         Exit Sub
      End If
   End If

   ' Open the log file.
   hLogFile = FreeFile
   Open Temp For Binary Access Write As hLogFile
   If Err Then
      MsgBox Error$, 48
      Close hLogFile
      hLogFile = 0
      Exit Sub
   Else
      ' Go to the end of the file so that new data can be appended.
      Seek hLogFile, LOF(hLogFile) + 1
   End If

   frmTerminal.Caption = "644Fast4System - " + OpenLog.FileTitle
   mnuOpenLog.Enabled = False
   mnuCloseLog.Enabled = True
End Sub

' This procedure sets the ParityReplace property, which holds the
' character that will replace any incorrect characters
' that are received because of a parity error.
Private Sub mnuParRep_Click()
    On Error Resume Next

    Temp = InputBox$("Enter Replace Character", "ParityReplace", frmTerminal.MSComm1.ParityReplace)
    frmTerminal.MSComm1.ParityReplace = Left$(Temp, 1)
    If Err Then MsgBox Error$, 48
End Sub



' This procedure sets the RThreshold property, which determines
' how many bytes can arrive at the receive buffer before the OnComm
' event is triggered and the CommEvent property is set to comEvReceive.
Private Sub mnuRThreshold_Click()
    On Error Resume Next
    
    Temp = InputBox$("Enter New RThreshold:", "RThreshold", Str$(MSComm1.RThreshold))
    If Len(Temp) Then
        MSComm1.RThreshold = Val(Temp)
        If Err Then MsgBox Error$, 48
    End If

End Sub


' The OnComm event is used for trapping communications events and errors.
Private Static Sub MSComm1_OnComm()
    Dim EVMsg$
    Dim ERMsg$
    
    ' Branch according to the CommEvent property.
    Select Case MSComm1.CommEvent
        ' Event messages.
        Case comEvReceive
            Dim Buffer As Variant
            Buffer = MSComm1.Input
            Debug.Print "Receive - " & StrConv(Buffer, vbUnicode)
            Temp_ReadProtocol (StrConv(Buffer, vbUnicode))
            ShowData frmData.txtTerm, (StrConv(Buffer, vbUnicode))
            
        Case comEvSend
        Case comEvCTS
            EVMsg$ = "Change in CTS Detected"
        Case comEvDSR
            EVMsg$ = "Change in DSR Detected"
        Case comEvCD
            EVMsg$ = "Change in CD Detected"
        Case comEvRing
            EVMsg$ = "The Phone is Ringing"
        Case comEvEOF
            EVMsg$ = "End of File Detected"

        ' Error messages.
        Case comBreak
            ERMsg$ = "Break Received"
        Case comCDTO
            ERMsg$ = "Carrier Detect Timeout"
        Case comCTSTO
            ERMsg$ = "CTS Timeout"
        Case comDCB
            ERMsg$ = "Error retrieving DCB"
        Case comDSRTO
            ERMsg$ = "DSR Timeout"
        Case comFrame
            ERMsg$ = "Framing Error"
        Case comOverrun
            ERMsg$ = "Overrun Error"
        Case comRxOver
            ERMsg$ = "Receive Buffer Overflow"
        Case comRxParity
            ERMsg$ = "Parity Error"
        Case comTxFull
            ERMsg$ = "Transmit Buffer Full"
        Case Else
            ERMsg$ = "Unknown error or event"
    End Select
    
    If Len(EVMsg$) Then
        ' Display event messages in the status bar.
        sbrStatus.Panels("Status").Text = "Status: " & EVMsg$
                
        ' Enable timer so that the message in the status bar
        ' is cleared after 2 seconds
        Timer2.Enabled = True
        
    ElseIf Len(ERMsg$) Then
        ' Display event messages in the status bar.
        sbrStatus.Panels("Status").Text = "Status: " & ERMsg$
        
        ' Display error messages in an alert message box.
        Beep
        Ret = MsgBox(ERMsg$, 1, "Click Cancel to quit, OK to ignore.")
        
        ' If the user clicks Cancel (2)...
        If Ret = 2 Then
            MSComm1.PortOpen = False    ' Close the port and quit.
        End If
        
        ' Enable timer so that the message in the status bar
        ' is cleared after 2 seconds
        Timer2.Enabled = True
    End If
End Sub

Private Sub mnuSendText_Click()
   Dim hSend, BSize, LF&
   
   On Error Resume Next
   
'   mnuSendText.Enabled = False
'   tbrToolBar.Buttons("TransmitTextFile").Enabled = False
   
'   ' Get the text filename from the user.
'   OpenLog.DialogTitle = "Send Text File"
'   OpenLog.Filter = "Text Files (*.TXT)|*.txt|All Files (*.*)|*.*"
'   Do
'      OpenLog.CancelError = True
'      OpenLog.FileName = ""
'      OpenLog.ShowOpen
'      If Err = cdlCancel Then
'        mnuSendText.Enabled = True
'        tbrToolBar.Buttons("TransmitTextFile").Enabled = True
'        Exit Sub
'      End If
'      Temp = OpenLog.FileName

'      ' If the file doesn't exist, go back.
'      Ret = Len(Dir$(Temp))
'      If Err Then
'         MsgBox Error$, 48
'         mnuSendText.Enabled = True
'         tbrToolBar.Buttons("TransmitTextFile").Enabled = True
'         Exit Sub
'      End If
'      If Ret Then
'         Exit Do
'      Else
'         MsgBox Temp + " not found!", 48
'      End If
'   Loop

   ' Open the log file.
'   hSend = FreeFile
'   Open Temp For Binary Access Read As hSend
'   If Err Then
'      MsgBox Error$, 48
'   Else
'      ' Display the Cancel dialog box.
'      CancelSend = False
'      frmCancelSend.Label1.Caption = "Transmitting Text File - " + Temp
'      frmCancelSend.Show
      
'      ' Read the file in blocks the size of the transmit buffer.
'      BSize = MSComm1.OutBufferSize
'      LF& = LOF(hSend)
'      Do Until EOF(hSend) Or CancelSend
'         ' Don't read too much at the end.
'         If LF& - Loc(hSend) <= BSize Then
'            BSize = LF& - Loc(hSend) + 1
'         End If
      
'         ' Read a block of data.
'         Temp = Space$(BSize)
'         Get hSend, , Temp
      
'         ' Transmit the block.
'         MSComm1.Output = Temp
'         If Err Then
'            MsgBox Error$, 48
'            Exit Do
'         End If
      
'         ' Wait for all the data to be sent.
'         Do
'            Ret = DoEvents()
'         Loop Until MSComm1.OutBufferCount = 0 Or CancelSend
'      Loop
'   End If
   
'   Close hSend
'   mnuSendText.Enabled = True
'   CancelSend = True
'   frmCancelSend.Hide

End Sub


' This procedure sets the SThreshold property, which determines
' how many characters (at most) have to be waiting
' in the output buffer before the CommEvent property
' is set to comEvSend and the OnComm event is triggered.
Private Sub mnuSThreshold_Click()
    On Error Resume Next
    
    Temp = InputBox$("Enter New SThreshold Value", "SThreshold", Str$(MSComm1.SThreshold))
    If Len(Temp) Then
        MSComm1.SThreshold = Val(Temp)
        If Err Then MsgBox Error$, 48
    End If
End Sub

' This procedure adds data to the Term control's Text property.
' It also filters control characters, such as BACKSPACE,
' carriage return, and line feeds, and writes data to
' an open log file.
' BACKSPACE characters delete the character to the left,
' either in the Text property, or the passed string.
' Line feed characters are appended to all carriage
' returns.  The size of the Term control's Text
' property is also monitored so that it never
' exceeds MAXTERMSIZE characters.
Private Static Sub ShowData(Term As Control, data As String)
    On Error GoTo Handler
    Const MAXTERMSIZE = 16000
    Dim TermSize As Long, i
        
    ' Make sure the existing text doesn't get too large.
    TermSize = Len(Term.Text)
    If TermSize > MAXTERMSIZE Then
       Term.Text = Mid$(Term.Text, 4097)
       TermSize = Len(Term.Text)
    End If

    ' Point to the end of Term's data.
    Term.SelStart = TermSize

    ' Filter/handle BACKSPACE characters.
    Do
       i = InStr(data, Chr$(8))
       If i Then
          If i = 1 Then
             Term.SelStart = TermSize - 1
             Term.SelLength = 1
             data = Mid$(data, i + 1)
          Else
             data = Left$(data, i - 2) & Mid$(data, i + 1)
          End If
       End If
    Loop While i

    ' Eliminate line feeds.
    Do
       i = InStr(data, Chr$(10))
       If i Then
          data = Left$(data, i - 1) & Mid$(data, i + 1)
       End If
    Loop While i

    ' Make sure all carriage returns have a line feed.
    i = 1
    Do
       i = InStr(i, data, Chr$(13))
       If i Then
          data = Left$(data, i) & Chr$(10) & Mid$(data, i + 1)
          i = i + 1
       End If
    Loop While i

    ' Add the filtered data to the SelText property.
    Term.SelText = data
'    Debug.Print data
        
    ' Log data to file if requested.
    If hLogFile Then
       i = 2
       Do
          Err = 0
          Put hLogFile, , data
          If Err Then
             i = MsgBox(Error$, 21)
             If i = 2 Then
                mnuCloseLog_Click
             End If
          End If
       Loop While i <> 2
    End If
    Term.SelStart = Len(Term.Text)
    
Exit Sub

Handler:
    MsgBox Error$
    Resume Next
End Sub

Private Sub Option1_Click()

    ListTempC.Visible = True
    ListTempF.Visible = False
    
End Sub

Private Sub Option2_Click()

    ListTempC.Visible = False
    ListTempF.Visible = True

End Sub

Private Sub Timer2_Timer()
sbrStatus.Panels("Status").Text = "Status: "
Timer2.Enabled = False

End Sub

' Keystrokes trapped here are sent to the MSComm
' control where they are echoed back via the
' OnComm (comEvReceive) event, and displayed
' with the ShowData procedure.
Private Sub txtTerm_KeyPress(KeyAscii As Integer)
    ' If the port is opened...
    If MSComm1.PortOpen Then
        ' Send the keystroke to the port.
        MSComm1.Output = Chr$(KeyAscii)
        
        ' Unless Echo is on, there is no need to
        ' let the text control display the key.
        ' A modem usually echos back a character
        If Not Echo Then
            ' Place position at end of terminal
            frmData.txtTerm.SelStart = Len(frmData.txtTerm)
            KeyAscii = 0
        End If
    End If
     
End Sub

Private Sub Timer1_Timer()
    ' Display the Connect Time
    sbrStatus.Panels("ConnectTime").Text = Format(Now - StartTime, "hh:nn:ss") & " "
End Sub
' Call this function to start the Connect Time timer
Private Sub StartTiming()
    StartTime = Now
    Timer1.Enabled = True
End Sub
' Call this function to stop timing
Private Sub StopTiming()
    Timer1.Enabled = False
    sbrStatus.Panels("ConnectTime").Text = ""
End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As MSComctlLib.Button)

Select Case Button.Key
Case "connect"
    Call mnuOpen_Click
    If MSComm1.PortOpen = True Then
        MSComm1.Output = Chr$(STX)
        MSComm1.Output = Chr$(PROCESS_STOP)
        MSComm1.Output = Chr$(ETX)
        MSComm1.Output = Chr$(STX)
        MSComm1.Output = Chr$(INIT_STATUS)
        MSComm1.Output = Chr$(ETX)
    End If
Case "disconnect"
    If MSComm1.PortOpen Then
        Call mnuOpen_Click
    End If
Case "graph_temp"
Case "temp_mini"
    TempMini.Show
    frmTerminal.Hide
End Select

End Sub
