/******************************************************************************
 * File     :  ra0ra1output.c
 * Purpose  :  Input Push Switch
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)
#use fast_io(A)              // programming of the direction register.


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   set_tris_a(0xF0);    // A5,A4 are inputs
                        // A3,A2,A1,A0 are outputs
   while(TRUE) {
      output_high(PIN_A0);
      delay_ms(100);
      output_low(PIN_A0);
      delay_ms(100);
      output_high(PIN_A1);
      delay_ms(100);
      output_low(PIN_A1);
      delay_ms(100);
   }
}
