/******************************************************************************
 * File     :  portio.c
 * Purpose  :  Port A operation
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_B2   // Define Transmitted Data
#define  RxD         PIN_B1   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#use fast_io(A)              // programming of the direction register.


/***********************************************************************
 * FUNCTION:     delay_seconds
 * DESCRIPTION:  delay time seconds
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void delay_seconds(int n) {

  for (; n!=0; n--)
  delay_ms(100);
}


/***********************************************************************
 * FUNCTION:     port_high
 * DESCRIPTION:  Output Port High
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void port_high(void) {

   output_high(PIN_A0);
   output_high(PIN_A1);
   output_high(PIN_A2);
   output_high(PIN_A3);
}


/***********************************************************************
 * FUNCTION:     port_low
 * DESCRIPTION:  Output Port Low
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void port_low(void) {

   output_low(PIN_A0);
   output_low(PIN_A1);
   output_low(PIN_A2);
   output_low(PIN_A3);
}


/***********************************************************************
 * FUNCTION:    main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int1 bit_chk=FALSE;

   set_tris_a(0x00);    // Set trisa all output
   port_high();
   delay_seconds(1);
   port_low();
   delay_seconds(1);

   set_tris_a(0xF0);    // Set trisa xx110000  RA5,RA4 Input RA3-RA0 output

   while(1) {
      if(!input(PIN_A5)) bit_chk = TRUE;
      if(!input(PIN_A4)) bit_chk = FALSE;

      if(bit_chk) {
         port_high();
      } else {
         port_low();
      }
   }
}
