/******************************************************************************
 * File     :  led7seg.c
 * Purpose  :  Drive LED 7 Segment Using B to digital output port
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#byte port_b=6                // set port_b to register portb (at address 0x06)


/***********************************************************************
 *	Constants
 ***********************************************************************/
char  num_led[17] = { 0x3F,0x06,0x5B,0x4F,0x66,  //0,1,2,3,4
   		             0x6D,0x7D,0x07,0x7F,0x6F,  //5,6,7,8,9
   	     	          0x77,0x7C,0x39,0x5E,0x79,  //A,b,C,d,E
	     	             0x71,0x80};				    //F,.


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void xDelay(int n);


/***********************************************************************
 * FUNCTION:     xDelay
 * DESCRIPTION:  Delay
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void xDelay(int n) {

  for (;n!=0; n--)
  delay_ms( 1000 );
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int i;

   set_tris_b(0x00);          // set trisb output

   while(TRUE)
   {
      for(i=0; i<17; i++)
      {
         port_b = num_led[i]; // show digit&char
         xDelay(1);           // delay
      }
   }
}
