/******************************************************************************
 * File     :  led7segn.c
 * Purpose  :  Drive LED 7 Segment Using B to digital output port
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#byte port_b=6                // set port_b to register portb (at address 0x06)


/***********************************************************************
 *	Constants
 ***********************************************************************/
char  num_led[16] = {0x3F,0x06,0x5B,0x4F,0x66,	//0,1,2,3,4
  	                  0x6D,0x7D,0x07,0x7F,0x6F,	//5,6,7,8,9
		               0x77,0x7C,0x39,0x5E,0x79,	//A,b,C,d,E
		               0x71};				         //F


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void DspLED7Seg(int c1, int c2, int c3);


/***********************************************************************
 * FUNCTION:     DspLED7Seg
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   c1, c2 ,c3
 * RETURNED:     nothing
 ***********************************************************************/
void DspLED7Seg(int c1, int c2, int c3) {

   port_b = num_led[c3];   // on led column 3
   output_low(PIN_A0);
   delay_ms(1);
   output_high(PIN_A0);

   port_b = num_led[c2];   // on led column 2
   output_low(PIN_A1);
   delay_ms(1);
   output_high(PIN_A1);

   port_b = num_led[c1];   // on led column 1
   output_low(PIN_A2);
   delay_ms(1);
   output_high(PIN_A2);
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int16 i;
   int j,c1,c2,c3;

   set_tris_a(0x00);    // set trisa output
   set_tris_b(0x00);    // set trisb output

   while(TRUE)
   {
      for(i=0; i<999; i++)
      {
         c1 = (i/100);
         c2 = (i%100)/10;
         c3 = (i%100)%10;

         for(j=0;j<100;j++)
            DspLED7Seg(c1, c2, c3);
      }
   }
}
