/******************************************************************************
 * File     :  led7sego.c
 * Purpose  :  Drive LED 7 Segment Using B to digital output port
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#byte port_b=6                // set port_b to register portb (at address 0x06)


/***********************************************************************
 *	Constants
 ***********************************************************************/
char  led_7seg[17] ={ 0x77, 0x73, 0x73,         // APP
                      0x6D, 0x5C, 0x71, 0x78,   // SOFT
                      0x78, 0x79, 0x39, 0x74,   // TECH
                      0x00, 0x00, 0x00,         // bank, bank, bank
                      0x77,0x6D,0x78            // AST
                      };

// 0x77, 0x39, 0x79 => A,C,E
// 0x71, 0x74, 0x5C => F,H,O
// 0x73, 0x6D, 0x78 => P,S,T


/***********************************************************************
 *	Data Types
 ***********************************************************************/
typedef short bit;
bit hook_dg2, hook_dg3;  // hook for dispaly


/***********************************************************************
 *	Global variables
 ***********************************************************************/
#define dp_7seg_LED  output_high(PIN_B7)
char dt1,dt2;            // delay time
                      

/***********************************************************************
 * FUNCTION:     dsp_digit1
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit1(char n) {

   output_high(PIN_A1);
   output_high(PIN_A2);
   port_b = led_7seg[n];
   output_low(PIN_A0);
   delay_ms(3-dt1-dt2);   // delay
}


/***********************************************************************
 * FUNCTION:     dsp_digit2
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit2(char n) {

   output_high(PIN_A0);
   output_high(PIN_A2);
   port_b = led_7seg[n];
   output_low(PIN_A1);
   delay_ms(dt1);        // delay
}


/***********************************************************************
 * FUNCTION:     dsp_digit3
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit3(char n) {

   output_high(PIN_A0);
   output_high(PIN_A1);
   port_b = led_7seg[n];
   output_low(PIN_A2);
   delay_ms(dt2);        // delay
}


/***********************************************************************
 * FUNCTION:    main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   char i,j;
   char cc;

   set_tris_a(0x00);    // set trisa output
   set_tris_b(0x00);    // set trisb output

   dt1 = 1;
   dt2 = 1;

   while(TRUE) {
      for(i=0; i<14; i++) {

         for(j=0; j<200; j++) {    // for display loop
            dsp_digit1(i);
            if(i>0) dsp_digit2(i-1);
            if(i>1) dsp_digit3(i-2);
         }

         if(i==13) {
            for(j=0; j<5; j++) {
               for(cc=0; cc<200; cc++) {
                  dsp_digit1(16);
                  dsp_digit2(15);
                  dsp_digit3(14);
               }
               output_high(PIN_A2);    // disable digit3
               delay_ms(500);          // delay
            }
         }
      }
   }
}
