/******************************************************************************
 * File     :  keyswm01.c
 * Purpose  :  Matrix Switch
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#define use_portb_kbd         // define for use portb kbd
#include "KBD.C"              // use module function

#define LED_DSP(x)   OUTPUT_C(x)


/***********************************************************************
 *	Constants
 ***********************************************************************/
char  num_led[4][3] = {{0x06, 0x5B, 0x4F},   // constants display LED 7 Segments
                       {0x66, 0x6D, 0x7D},
          				  {0x07, 0x7F, 0x6F},
                       {0x63, 0x3F, 0x76} };


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void xkbd_init(void);
void CheckKeyPress(void);


/***********************************************************************
 * FUNCTION:     xkbd_init()
 * DESCRIPTION:  keyboard init
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void xkbd_init() {
#ifdef __PCM__
    port_b_pullups(true);   // If not PCM be sure to use external pullups
#endif
}


/***********************************************************************
 * FUNCTION:     CheckKeyPress
 * DESCRIPTION:  check key press
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void CheckKeyPress(void) {

   char c;
   int i,j;

   c = kbd_getc();

   for(i=0;i<4;i++)
   for(j=0;j<3;j++)
   if( KEYS[i][j] == c) {
       LED_DSP(num_led[i][j]);
   }
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   xkbd_init();         // keyboard init

   set_tris_c(0x00);    // set trisc output

   LED_DSP(num_led[0][0]);
   while(TRUE) {
		CheckKeyPress();
	}
}
