/******************************************************************************
 * File     :  keyswm01.c
 * Purpose  :  Matrix Switch
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#include <16F877.h>           // Microchip 14 bit (14 bit opcodes)
// Device Specification
#fuses HS                     // Oscillator
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code protection
// Built-in Libraries
#use delay (clock=20000000)   // use built-in function: delay_ms() & delay_us()

#define use_portb_kbd         // define for use portb kbd
#include "KBD.C"              // use module function

#define LED_DSP(x)   OUTPUT_C(x)

/***********************************************************************
 *	Internal Constants
 ***********************************************************************/
char  num_led[4][3] = {{0x06, 0x5B, 0x4F},   // constants display LED 7 Segments
                       {0x66, 0x6D, 0x7D},
          				  {0x07, 0x7F, 0x6F},
                       {0x63, 0x3F, 0x76} };

/***********************************************************************
 *	Internal Functions
 ***********************************************************************/
void CheckKeyPress(void);
void xkbd_init(void);

void xkbd_init() {
#ifdef __PCM__
    port_b_pullups(true);   // If not PCM be sure to use external pullups
#endif
}

/***********************************************************************
 * FUNCTION:     CheckKeyPress
 * DESCRIPTION:  check key press
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void CheckKeyPress(void) {

   char c;
   int i,j;

   c = kbd_getc();

   for(i=0;i<4;i++)
   for(j=0;j<3;j++)
   if( KEYS[i][j] == c) {
       LED_DSP(num_led[i][j]);
   }
}

void main(void) {

   xkbd_init();
   
   set_tris_c(0x00);    // set trisc output

   LED_DSP(num_led[0][0]);
   while(TRUE) {
		CheckKeyPress();
	}
}
