/*************************************************************
Program:      Matrix Switch
Description:  Using port B and C
File name:    ex01.c
Write:          APPSOFTTECH CO.,LTD (http://www.appsofttech.com)
Compiler:    PCW Compiler (PCB and PCM Version 3.050)
Hardware:   NX-877 PIC16F877
Comment:   Configuration Oscillator HS
                  Port B Matrix Switch
                  Port C LED 7 Segment
**************************************************************/

#if defined(__PCM__)
#include <16F877.h>
#fuses HS, NOLVP, NOWDT, NOPROTECT
#use delay (clock=20000000)
#byte kbd = 6
#endif

//#define COL0 (1 << 2)      //     100     B2
//#define COL1 (1 << 3)      //    1000     B3
//#define COL2 (1 << 6)      // 1000000     B6

//#define ROW0 (1 << 4)      //    10000    B4
//#define ROW1 (1 << 7)      // 10000000    B7
//#define ROW2 (1 << 1)      //       10    B1
//#define ROW3 (1 << 5)      //   100000    B5

#define COL0 (1 << 5)      //   100000    B5
#define COL1 (1 << 6)      // 1000000     B6
#define COL2 (1 << 7)      // 10000000    B7

#define ROW0 (1 << 1)      //       10    B1
#define ROW1 (1 << 2)      //     100     B2
#define ROW2 (1 << 3)      //    1000     B3
#define ROW3 (1 << 4)      //    10000    B4


#define ALL_ROWS (ROW0|ROW1|ROW2|ROW3)       // 10110010 or 0xB2
#define ALL_PINS (ALL_ROWS|COL0|COL1|COL2)   // 11111110 or 0xFE

// Keypad layout:
char const KEYS[4][3] = {{'1','2','3'},
                         {'4','5','6'},
                         {'7','8','9'},
                         {'*','0','#'}};

#define LED_DSP(x)   OUTPUT_C(x)

unsigned char  num_led[4][3] = {{0x06, 0x5B, 0x4F},
	                             {0x66, 0x6D, 0x7D},
                    			     {0x07, 0x7F, 0x6F},
                                {0x63, 0x3F, 0x76} };

#define KBD_DEBOUNCE_FACTOR 33    // Set this number to apx n/333 where
                                  // n is the number of times you expect
                                  // to call kbd_getc each second

void kbd_init() {
#ifdef __PCM__
    port_b_pullups(true);   // If not PCM be sure to use external pullups
#endif
}

char kbd_getc( ) {
   static byte kbd_call_count;
   static short int kbd_down;
   static char last_key;
   static byte col;

   byte kchar;
   byte row;

   kchar='\0';
   if(++kbd_call_count>KBD_DEBOUNCE_FACTOR) {
       switch (col) {
         case 0   : set_tris_b(ALL_PINS&~COL0);    // 11111010 or 0xFA
                    kbd=~COL0&ALL_PINS;
                    break;
         case 1   : set_tris_b(ALL_PINS&~COL1);    // 11110110 or 0xF6
                    kbd=~COL1&ALL_PINS;
                    break;
         case 2   : set_tris_b(ALL_PINS&~COL2);    // 10111110 or 0xBE
                    kbd=~COL2&ALL_PINS;
                    break;
       }

       if(kbd_down) {
         if((kbd & (ALL_ROWS))==(ALL_ROWS)) {
           kbd_down=false;
           kchar=last_key;
           last_key='\0';
         }
       } else {
          if((kbd & (ALL_ROWS))!=(ALL_ROWS)) {
             if((kbd & ROW0)==0)
               row=0;
             else if((kbd & ROW1)==0)
               row=1;
             else if((kbd & ROW2)==0)
               row=2;
             else if((kbd & ROW3)==0)
               row=3;
             last_key =KEYS[row][col];
             kbd_down = true;
          } else {
             ++col;
             if(col==3)
               col=0;
          }
       }
      kbd_call_count=0;
   }
  set_tris_b(ALL_PINS);
 return(kchar);
}

void CheckKeyPress(void)
{
   char c;
   int i,j;

   c = kbd_getc();

   for(i=0;i<4;i++)
   for(j=0;j<3;j++)
     if( KEYS[i][j] == c)
     {  LED_DSP(num_led[i][j]);
     }

}

void main(void) {

   kbd_init();
   set_tris_c(0x00);    // set trisc output

   LED_DSP(num_led[0][0]);
   while(1) {
		CheckKeyPress();
	}
}
