/******************************************************************************
 * File     :  keyswm02.c
 * Purpose  :  Matrix Switch Multiplex
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#define use_portb_kbd         // define for use portb kbd
#include "KBD.C"              // use module function

#define LED_DSP(x)   OUTPUT_C(x)


/***********************************************************************
 *	Constants
 ***********************************************************************/
 char  num_led[12] = {0x06, 0x5B, 0x4F,   // constants display LED 7 Segments
                      0x66, 0x6D, 0x7D,
          		       0x07, 0x7F, 0x6F,
                      0x63, 0x3F, 0x76
                     };


/***********************************************************************
 *	Global variables
 ***********************************************************************/
char dt1,dt2;        // delay time


/***********************************************************************
 *	Functions prototypes
 ***********************************************************************/
void xkbd_init(void);
void CheckKeyPress(void);
void dsp_digit1(char n);
void dsp_digit2(char n);
void dsp_digit3(char n);
int atoc(char c);


/***********************************************************************
 * FUNCTION:     dsp_digit1
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit1(char n) {

   output_high(PIN_A1);
   output_high(PIN_A2);
   LED_DSP(num_led[n]);
   output_low(PIN_A0);
   delay_ms(3-dt1-dt2);
}


/***********************************************************************
 * FUNCTION:     dsp_digit2
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit2(char n) {

   output_high(PIN_A0);
   output_high(PIN_A2);
   LED_DSP(num_led[n]);
   output_low(PIN_A1);
   delay_ms(dt1);
}


/***********************************************************************
 * FUNCTION:     dsp_digit3
 * DESCRIPTION:  Display LED 7 Segments
 * PARAMETERS:   n
 * RETURNED:     nothing
 ***********************************************************************/
void dsp_digit3(char n) {

   output_high(PIN_A0);
   output_high(PIN_A1);
   LED_DSP(num_led[n]);
   output_low(PIN_A2);
   delay_ms(dt2);
}


/***********************************************************************
 * FUNCTION:     atoc
 * DESCRIPTION:  Converts the char to int
 * PARAMETERS:   c
 * RETURNED:     nothing
 ***********************************************************************/
int atoc(char c) {

   int i;

   i = c -'1';
   if(c=='*') i = 9;
   if(c=='0') i = 10;
   if(c=='#') i = 11;

   return(i);
}


/***********************************************************************
 * FUNCTION:     xkbd_init()
 * DESCRIPTION:  keyboard init
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void xkbd_init() {
#ifdef __PCM__
    port_b_pullups(true);   // If not PCM be sure to use external pullups
#endif
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int i, c1,c2,c3;
   char ch;

   xkbd_init();         // keyboard init

   set_tris_a(0x00);    // set trisa output
   set_tris_c(0x00);    // set trisc output

   dt1 = 1;
   dt2 = 1;

   i = 0;

   while(TRUE) {

      ch = kbd_getc();
      if(ch!=0) {
         i++;
         if(i>2) {
            c3 = c2;
            i = 3;
         }
         if(i>1) c2 = c1;
         c1 = atoc(ch);
      }

      dsp_digit1(c1);
      if(i>1) dsp_digit2(c2);
      if(i>2) dsp_digit3(c3);
   }
}
