/******************************************************************************
 * File     :  intext.c
 * Purpose  :  RB0/INT External Interrupt
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#byte portb = 6            // PORTB Register
#byte portb_tris = 0x86    // TRISB Register


/***********************************************************************
 *	Constants
 ***********************************************************************/
BOOLEAN HOOKEXT=FALSE;


/***********************************************************************
 * FUNCTION:     IntExt_isr
 * DESCRIPTION:  External Interrupt
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
#INT_EXT
void IntExt_isr(void) {

   HOOKEXT = TRUE;
}


/***********************************************************************
 * FUNCTION:     Led7SegRun
 * DESCRIPTION:  LED 7 Segments Running
 * PARAMETERS:   i
 * RETURNED:     nothing
 ***********************************************************************/
void Led7SegRun(int i) {

   portb |= (1<<i);
   delay_ms(500);
   portb = 0x00;
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {
   int i=1;

   enable_interrupts(GLOBAL);    // Enable Global Interrupts
   enable_interrupts(INT_EXT);   // Enable External Interrupts

   portb_tris = 0x01;            // Set TRISB RB1-RB7 output, RB0 input

   while(TRUE) {

      if(HOOKEXT) {
         delay_ms(500);
         HOOKEXT = FALSE;
      } else {
         Led7SegRun(i++);
         if(i>7) i=1;
      }
   }
}
