/******************************************************************************
 * File     :  timer1.c
 * Purpose  :  Timer1 Demo
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Data Types
 ***********************************************************************/
 struct time {    // structure of the time record
   int hour;      // hour
   int min;       // minute
   int sec;       // second
};


/***********************************************************************
 *	Global variables
 ***********************************************************************/
struct time tmr1;
int16 overflow=0;


/***********************************************************************
 * FUNCTION:     IntTMR1_isr
 * DESCRIPTION:  Interrupt Timer1
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
#INT_TIMER1
void IntTMR1_isr(void) {

   overflow++;
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the application.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   enable_interrupts(GLOBAL);       // enable interrupt global
   enable_interrupts(INT_TIMER1);   // enable interrupt timer1

   setup_timer_1(T1_INTERNAL | T1_DIV_BY_4); // setup timer1
   set_timer1(0);                   // set timer1

   tmr1.hour =23;    // set hour
   tmr1.min = 54;    // set min
   tmr1.sec = 38;    // set sec

   printf("\r\nInterrupt Timer1\n\n");

   while(TRUE) {

      if(overflow>18) {
         overflow = 0;
         if(++tmr1.sec==60) {         // calculate the second
            tmr1.sec = 0;
            if(++tmr1.min==60) {      // calculate the minute
               tmr1.min = 0;
               if(++tmr1.hour==24) {  // calculate the hour
                  tmr1.hour = 0;
               }
            }
         }
      }
      printf("\rClock Time: %02d:%02d:%02d",tmr1.hour,tmr1.min,tmr1.sec);
   }
}
