/******************************************************************************
 * File     :  rs232led.c
 * Purpose  :  RS232 I/O Control
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_B2   // Define Transmitted Data
#define  RxD         PIN_B1   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)

#byte portb = 6               // Address Register PORTB = 0x06


/***********************************************************************
 * FUNCTION:     LED_Control
 * DESCRIPTION:  On/Off LED PORTB
 * PARAMETERS:   led
 * RETURNED:     nothing
 ***********************************************************************/
void LedControl(unsigned int led) {

   portb = 0x00;        // clear led
   portb |= (1<<led);   // High LED
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int i;
   char digit;

   set_tris_b(0x00);    // B0-B7 are outputs
   portb = 0x00;        // clear led

   while(TRUE) {
      printf("\n\rInput 0-7 Number LED : ");
      digit = getc();
      putc(digit);
      if(digit<='8') {
         i= digit-'0';
         LedControl(i);
      } else {
         puts(" (Invalid Number)");
      }
   }
}
