/******************************************************************************
 * File     :  capture.c
 * Purpose  :  CPP1 Capture Mode
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Global variables
 ***********************************************************************/
float time1,time2;
BOOLEAN hook_cpp1=TRUE, HookRise=TRUE;


/***********************************************************************
 * FUNCTION:     Capture Interrupt
 * DESCRIPTION:  CCP1 capture mode
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
#int_ccp1
void capture_isr() {

   if(HookRise) {
      time1 = get_timer1();
      HookRise = FALSE;
   } else {
      time2 = get_timer1();
      HookRise = TRUE;
      hook_cpp1 = FALSE;
   }
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   float tms;

   setup_ccp1(CCP_CAPTURE_RE);               // Configure CCP1 to capture rise
   setup_timer_1(T1_INTERNAL|T1_DIV_BY_8);   // Setup timer 1

   enable_interrupts(INT_CCP1);              // Enable interrupt CCP1
   enable_interrupts(GLOBAL);                // All interrupts ON

   set_timer1(0);                            // Start timer
   while(hook_cpp1)
         ;
#ifdef _PIC16F877_
   tms = (time2-time1)*8*200*0.000000001;
#else
   tms = (time2-time1)*8*1000*0.000000001;
#endif

   printf("\rTime of capture: %9.3e ms Frequency: %f Hz ", tms,1/tms);

   while(TRUE);
}
