/******************************************************************************
 * File     :  compare.c
 * Purpose  :  CPP1 Compare Mode
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)

#endif

// Device Specification
#fuses HS                     // Oscillator HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 *	Global variables
 ***********************************************************************/
int16 time;


/***********************************************************************
 * FUNCTION:     Compare Interrupt
 * DESCRIPTION:  CCP1 compare mode
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
#INT_CCP1
void compare_isr() {

   time = get_timer1();              // Get Timer1
   printf("\r\nCompare set interrupt");
   printf("\r\nTimer1: %lu us",time);
   disable_interrupts(GLOBAL);       // All interrupts OFF
   disable_interrupts(INT_CCP1);     // Disable interrupt CCP1
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   setup_ccp1(CCP_COMPARE_INT);     // Interrupt on compare mode
   setup_timer_1(T1_INTERNAL);      // Set up timer to instruction clk

   enable_interrupts(INT_CCP1);     // Enable interrupt CCP1
   enable_interrupts(GLOBAL);       // All interrupts ON

   set_timer1(0);                   // Set Timer1
   CCP_1 = 500;                     // Set high time limit to 100 us
                                    // limit is time/(clock/4)
                                    // 500 = .0001*(20000000/4)
   while(TRUE);
}
