/******************************************************************************
 * File     :  analoginput.c
 * Purpose  :  Using port A to anolog input port
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)
// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection

#device ADC=10                // ADC 10 Bit  (1111111111=1,023)

#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)
#use fast_io(A)               // programming of the direction register.


/***********************************************************************
 *	Constants
 ***********************************************************************/
#define Vbe   0.0048875855327468230694037145650049   // Vref/1023 (5/1023)


/***********************************************************************
 * FUNCTION:    main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   int16 value;
   float volt;

   printf("Analog to digital port A :");
   setup_port_a(ALL_ANALOG);           // A0 A1 A2 A3 A5 E0 E1 E2 Ref=Vdd
   setup_adc(ADC_CLOCK_INTERNAL);      // Clock RC
   set_adc_channel(0);                 // Read Analog input RA0(channel=0)

   do {
      value = Read_ADC();
      printf("\n\rADC : %ld",value);
      volt = Vbe * (float) value;
      printf("\n\rRA0 Voltage : %f\n",volt);
      delay_ms(1000);
   } while (TRUE);
}
