/******************************************************************************
 * File     :  rweeprom.c
 * Purpose  :  Read/Write Internal EEPROM
 * Author   :  Prajin Palangsantikul
 * E-mail   :  prajin@appsofttech.com
 * Release  :  PCW Compiler 3.180
 * Copyright (c) 2004 APPSOFTTECH CO.,LTD.
 *****************************************************************************/

#define _PIC16F877_           // Use PIC16F877 device

#ifdef _PIC16F877_
#include <16F877.h>           // Standard Header file for the PIC16F877 device
#define  TxD         PIN_C6   // Define Transmitted Data
#define  RxD         PIN_C7   // Define Received Data
#define  CLOCK_SP    20000000 // Clock Speed(Hz)
#define  MAX_DATA_EEPROM   256 // Data EEPROM in PIC16F877

#else
#include <16F628.h>           // Standard Header file for the PIC16F628 device
#define  TxD         PIN_A2   // Define Transmitted Data
#define  RxD         PIN_A3   // Define Received Data
#define  CLOCK_SP    4000000  // Clock Speed(Hz)
#define  MAX_DATA_EEPROM   112 // Data EEPROM in PIC16F628

#endif

// Device Specification
#fuses HS                     // Oscillator mode HS
#fuses NOLVP, NOWDT           // No Low Voltage Program, No Watchdog timer
#fuses NOPROTECT              // Code no protection
#use delay (clock=CLOCK_SP)   // Use built-in function: delay_ms() & delay_us()
#use rs232(baud=9600, xmit=TxD,rcv=RxD) // Use serial I/O port (RS232)


/***********************************************************************
 * FUNCTION:     WriteIntEEPROM
 * DESCRIPTION:  Write Internal EEPROM
 * PARAMETERS:   addr, value
 * RETURNED:     nothing
 ***********************************************************************/
void WriteIntEEPROM(byte addr, byte value) {

   write_eeprom(addr,value);   // wirte eeprom
}


/***********************************************************************
 * FUNCTION:     ReadIntEEPROM
 * DESCRIPTION:  Read Internal EEPROM
 * PARAMETERS:   nothing
 * RETURNED:     nothing
 ***********************************************************************/
void ReadIntEEPROM(void) {
   int16 volume,i=0;
   byte buffer;

   for(volume=0; volume<MAX_DATA_EEPROM-1; volume++) {
      buffer = read_eeprom(volume);
      printf ("%c[%x],", buffer,buffer);
      if(i++>8) {
         puts("");
         i = 0;
      }
   }
}


/***********************************************************************
 * FUNCTION:    Main
 * DESCRIPTION: This is the main entry point for the program.
 * PARAMETERS:  nothing
 * RETURNED:    nothing
 ***********************************************************************/
void main(void) {

   char ch;
   int16 addr=0;

   while(TRUE) {

      printf("\r\nRead,Wirte EEPROM (R,W): ");
      ch = getc();
      putc(ch);
      if(toupper(ch) == 'R') {
         puts("\r\nData in EEPROM");
         ReadIntEEPROM();              // Read EEPROM
      }

      if(toupper(ch) == 'W') {
         do {
            printf("\r\nInput data (exit 0) : ");
            ch = getc();
            putc(ch);
            WriteIntEEPROM(addr, ch);  // Write EEPROM
            if(addr++>=(MAX_DATA_EEPROM-1)) addr = 0;
         }while(ch != '0');
      }

   }
}
